using Sandbox;
using System.Threading.Tasks;

public class PlayerData
{
	public int Level { get; set; } // Will be serialized
	public int MaxHealth { get; set; } // Will be serialized
	public string Username; // Won't be serialized

	public static void Save( PlayerData data )
	{
		FileSystem.Data.WriteJson( "player.json", AntiTamper.Lock( data, 1254854 ) );
	}

	public static PlayerData Load()
	{
		return AntiTamper.Unlock(
			FileSystem.Data.ReadJson<LockedData>( "player.json" ),
			1254854,
			new PlayerData()
		);
	}
}

public sealed class GameLogic : Component
{
	[Property] SkinnedModelRenderer Body { get; set; }

	float _clicksPerSecond;
	PlayerData data;

	protected override void OnEnabled()
	{
		try
		{
			data = PlayerData.Load();
		} catch
		{
			Log.Info( "Naughty cheater!" );
			data = new PlayerData();
		}
	}
	protected override void OnDisabled()
	{
		PlayerData.Save( data );
	}

	protected override void OnUpdate()
	{
		if (Input.Pressed("Attack1"))
		{
			_clicksPerSecond++;
			_ = RemoveClick();
			data.Level++;
		}

		DebugOverlay.ScreenText( 25, data.Level.ToString() );
		Body.Set( "thrill", _clicksPerSecond / 8f );
	}
	
	async Task RemoveClick()
	{
		await Task.Delay( 1000 );
		_clicksPerSecond--;
	}
}
